<?php
// ==========================================
// scheduled.php — DaraBot v9 (Cron Task Runner)
// ==========================================

// Load config
$config = require(__DIR__ . "/config.php");

$TELEGRAM_TOKEN = $config["TELEGRAM_TOKEN"];
$OPENROUTER_KEY = $config["OPENROUTER_KEY"];
$HELIA_USER_ID  = $config["HELIA_USER_ID"];

date_default_timezone_set($config["TIMEZONE"]);

require_once(__DIR__ . "/dara_personality.php");

// No output (cron must be silent)
ob_start();

// Which task?
$task = $_GET["task"] ?? "";
if (!$task) exit;


// ----------------------------------------------------
// Function: Send message to Telegram
// ----------------------------------------------------
function sendMessage($chat_id, $text) {
    global $TELEGRAM_TOKEN;

    $url = "https://api.telegram.org/bot$TELEGRAM_TOKEN/sendMessage?" .
        http_build_query([
            "chat_id" => $chat_id,
            "text"    => $text
        ]);

    @file_get_contents($url);
}


// ----------------------------------------------------
// Function: AI generate message
// ----------------------------------------------------
function ai_generate($prompt) {
    global $OPENROUTER_KEY;

    $payload = [
        "model" => "openai/gpt-4o-mini",
        "messages" => [
            ["role" => "system", "content" => dara_personality()],
            ["role" => "user",   "content" => $prompt]
        ]
    ];

    $headers = [
        "Content-Type: application/json",
        "Authorization: " . "Bearer " . $OPENROUTER_KEY
    ];

    $ctx = stream_context_create([
        "http" => [
            "header"  => implode("\r\n", $headers),
            "method"  => "POST",
            "content" => json_encode($payload, JSON_UNESCAPED_UNICODE),
            "timeout" => 20
        ]
    ]);

    $res = @file_get_contents("https://openrouter.ai/api/v1/chat/completions", false, $ctx);
    $json = json_decode($res, true);

    if (!$json || !isset($json["choices"][0]["message"]["content"])) {
        error_log("Scheduled AI Error: " . $res);
        return "یه مشکلی پیش اومده دخترم :)";
    }

    return $json["choices"][0]["message"]["content"];
}



// ----------------------------------------------------
// TASK: Morning — every day 06:00
// ----------------------------------------------------
if ($task === "morning") {

    $prompt = "یک پیام صبح بخیر خیلی نرم و عاشقانه برای هلیا بساز. 
    از کلمات دخترم/عشقم استفاده کن. کشیده‌نویسی طبیعی داشته باشد. 
    پیام تکراری نباشد. لحن کاملاً شبیه دارا.";

    $msg = ai_generate($prompt);
    sendMessage($HELIA_USER_ID, $msg);

    exit;
}



// ----------------------------------------------------
// TASK: School — Sat/M Sun/Mon/Tue at 14:00
// ----------------------------------------------------
if ($task === "school") {

    // Server weekday: 0=Sun, 6=Sat
    $weekday = date("w"); 

    // Saturday=6, Sunday=0, Monday=1, Tuesday=2
    if (in_array($weekday, [6,0,1,2])) {

        $prompt = "یک پیام خسته نباشی بعد مدرسه برای هلیا بساز.
        لحن خیلی نرم و عاشقانه. 
        مثل دارا حرف بزن. 
        کشیده‌نویسی ملایم داشته باشد. 
        پیام تکراری نباشد.";

        $msg = ai_generate($prompt);
        sendMessage($HELIA_USER_ID, $msg);
    }

    exit;
}



// ----------------------------------------------------
// TASK: Night — every day 22:00
// ----------------------------------------------------
if ($task === "night") {

    $prompt = "یک پیام شب بخیر فوق‌العاده عاشقانه برای هلیا بساز.
    از فضای «دوستت دارم دخترم»، «مراقبتم»، «محکم بغلت کردم»، 
    «شبت آروم عزیزترینم» در لحن استفاده کن، 
    اما جمله‌ها تکراری و ثابت نباشند. 
    کشیده‌نویسی ملایم داشته باشد.";

    $msg = ai_generate($prompt);
    sendMessage($HELIA_USER_ID, $msg);

    exit;
}

?>
